"""Simple RAG query example."""
import os
from langchain_openai import ChatOpenAI, OpenAIEmbeddings
from langchain_community.vectorstores import PGVector
from langchain.chains import RetrievalQA

def main():
    embeddings = OpenAIEmbeddings(api_key=os.getenv("OPENAI_API_KEY"))
    vectorstore = PGVector(
        connection_string=os.getenv("DATABASE_URL"),
        embedding_function=embeddings,
        collection_name="docs",
    )
    llm = ChatOpenAI(model="gpt-4o-mini", api_key=os.getenv("OPENAI_API_KEY"))
    qa = RetrievalQA.from_chain_type(llm, retriever=vectorstore.as_retriever())
    print(qa.invoke("What is this document about?"))

if __name__ == "__main__":
    main()
