"""Multi-agent orchestrator with supervisor pattern."""
import os
from langgraph.prebuilt import create_react_agent
from langchain_openai import ChatOpenAI
from langchain_core.tools import tool

@tool
def search(query: str) -> str:
    """Search for information."""
    return f"Results for: {query}"

def build_supervisor():
    llm = ChatOpenAI(model="gpt-4o-mini", api_key=os.getenv("OPENAI_API_KEY"))
    agent = create_react_agent(llm, tools=[search])
    return agent

def main():
    agent = build_supervisor()
    for chunk in agent.stream({"messages": [("user", "Search for LangGraph docs")]}):
        if "messages" in chunk:
            for m in chunk["messages"]:
                if hasattr(m, "content") and m.content:
                    print(m.content, end="")
    print()

if __name__ == "__main__":
    main()
