"""LangGraph agent with tool calling and streaming."""
import os
from langgraph.prebuilt import create_react_agent
from langchain_openai import ChatOpenAI
from langchain_core.tools import tool

@tool
def get_weather(location: str) -> str:
    """Get current weather for a location."""
    return f"Weather in {location}: sunny, 22°C"

def main():
    llm = ChatOpenAI(model="gpt-4o-mini", api_key=os.getenv("OPENAI_API_KEY"))
    agent = create_react_agent(llm, tools=[get_weather])
    for chunk in agent.stream({"messages": [("user", "What's the weather in Berlin?")]}):
        if "messages" in chunk:
            for msg in chunk["messages"]:
                if hasattr(msg, "content") and msg.content:
                    print(msg.content, end="")
    print()

if __name__ == "__main__":
    main()
