"""Celery app with multi-queue routing."""
from celery import Celery
import os

app = Celery(
    "worker",
    broker=os.getenv("REDIS_URL", "redis://localhost:6379/0"),
    backend=os.getenv("REDIS_URL", "redis://localhost:6379/0"),
    include=["tasks"],
)
app.conf.task_routes = {
    "tasks.high_priority": {"queue": "high"},
}
app.conf.task_default_retry_delay = 60
